--[[
/**
 * @file       uC3Std.lua
 * @author     Copyright (c) 2013 eForce Co.,Ltd. All Rights Reserved.
 * @brief      Basic lua module for uC3/Standard
 *             This module should deploy at same directory as configurator.exe. ex) \lua\uC3Std.lua
 * @revisions
 *             - rev 1.00 (2013-09-20)
 *               First public release.
 */
--]]
module("uC3Std", package.seeall)

-- IuWFNg
TA_NULL = 0

TA_HLNG = 0x00
TA_ASM  = 0x01

TA_ACT  = 0x02
TA_RSTR = 0x04
TA_AUX  = 0x10
TA_DSP  = 0x20
TA_FPU  = 0x40
TA_VPU  = 0x80

TA_TFIFO    = 0x00
TA_TPRI     = 0x01

TA_MFIFO    = 0x00
TA_MPRI     = 0x02

TA_WSGL = 0x00
TA_WMUL = 0x02
TA_CLR  = 0x04

TA_INHERIT  = 0x02
TA_CEILING  = 0x03

TA_STA  = 0x02
TA_PHS  = 0x04

TA_USR  = 0x10

-- CPUOnhԍ Cortex-A
EXC_UDF = 1
EXC_SVC = 2
EXC_PRA = 3
EXC_DTA = 4

-- hCoŎgpĂȂ[Uo^
function task_count_usr()
    local usr_cnt = 0
    local all_cnt = MCFGGetParamInteger("CFG_TSK_COUNT", 0)
    if all_cnt > 0 then
        for i = 0, all_cnt-1 do
            tsk = MCFGGetKernelStdTask(i)
            if tsk:externaluse() == false then
                usr_cnt = usr_cnt + 1
            end
        end
    end
    return usr_cnt
end

function sem_count_usr()
    local usr_cnt = 0
    local all_cnt = MCFGGetParamInteger("CFG_SEM_COUNT", 0)
    if all_cnt > 0 then
        for i = 0, all_cnt-1 do
            sem = MCFGGetKernelStdSemaphore(i)
            if sem:externaluse() == false then
                usr_cnt = usr_cnt + 1
            end
        end
    end
    return usr_cnt
end

function flg_count_usr()
    local usr_cnt = 0
    local all_cnt = MCFGGetParamInteger("CFG_FLG_COUNT", 0)
    if all_cnt > 0 then
        for i = 0, all_cnt-1 do
            flg = MCFGGetKernelStdEventFlage(i)
            if flg:externaluse() == false then
                usr_cnt = usr_cnt + 1
            end
        end
    end
    return usr_cnt
end

function dtq_count_usr()
    local usr_cnt = 0
    local all_cnt = MCFGGetParamInteger("CFG_DTQ_COUNT", 0)
    if all_cnt > 0 then
        for i = 0, all_cnt-1 do
            dtq = MCFGGetKernelStdDataQueue(i)
            if dtq:externaluse() == false then
                usr_cnt = usr_cnt + 1
            end
        end
    end
    return usr_cnt
end

function mbx_count_usr()
    local usr_cnt = 0
    local all_cnt = MCFGGetParamInteger("CFG_MBX_COUNT", 0)
    if all_cnt > 0 then
        for i = 0, all_cnt-1 do
            mbx = MCFGGetKernelStdMailbox(i)
            if mbx:externaluse() == false then
                usr_cnt = usr_cnt + 1
            end
        end
    end
    return usr_cnt
end

function mtx_count_usr()
    local usr_cnt = 0
    local all_cnt = MCFGGetParamInteger("CFG_MTX_COUNT", 0)
    if all_cnt > 0 then
        for i = 0, all_cnt-1 do
            mtx = MCFGGetKernelStdMutex(i)
            if mtx:externaluse() == false then
                usr_cnt = usr_cnt + 1
            end
        end
    end
    return usr_cnt
end

function mbf_count_usr()
    local usr_cnt = 0
    local all_cnt = MCFGGetParamInteger("CFG_MBF_COUNT", 0)
    if all_cnt > 0 then
        for i = 0, all_cnt-1 do
            mbf = MCFGGetKernelStdMessageBuffer(i)
            if mbf:externaluse() == false then
                usr_cnt = usr_cnt + 1
            end
        end
    end
    return usr_cnt
end

function por_count_usr()
    local usr_cnt = 0
    local all_cnt = MCFGGetParamInteger("CFG_POR_COUNT", 0)
    if all_cnt > 0 then
        for i = 0, all_cnt-1 do
            por = MCFGGetKernelStdRendezvous(i)
            if por:externaluse() == false then
                usr_cnt = usr_cnt + 1
            end
        end
    end
    return usr_cnt
end

function mpf_count_usr()
    local usr_cnt = 0
    local all_cnt = MCFGGetParamInteger("CFG_MPF_COUNT", 0)
    if all_cnt > 0 then
        for i = 0, all_cnt-1 do
            mpf = MCFGGetKernelStdFixedMemPool(i)
            if mpf:externaluse() == false then
                usr_cnt = usr_cnt + 1
            end
        end
    end
    return usr_cnt
end

function mpl_count_usr()
    local usr_cnt = 0
    local all_cnt = MCFGGetParamInteger("CFG_MPL_COUNT", 0)
    if all_cnt > 0 then
        for i = 0, all_cnt-1 do
            mpl = MCFGGetKernelStdVariableMemPool(i)
            if mpl:externaluse() == false then
                usr_cnt = usr_cnt + 1
            end
        end
    end
    return usr_cnt
end

function cyc_count_usr()
    local usr_cnt = 0
    local all_cnt = MCFGGetParamInteger("CFG_CYC_COUNT", 0)
    if all_cnt > 0 then
        for i = 0, all_cnt-1 do
            cyc = MCFGGetKernelStdCyclicHandler(i)
            if cyc:externaluse() == false then
                usr_cnt = usr_cnt + 1
            end
        end
    end
    return usr_cnt
end

function alm_count_usr()
    local usr_cnt = 0
    local all_cnt = MCFGGetParamInteger("CFG_ALM_COUNT", 0)
    if all_cnt > 0 then
        for i = 0, all_cnt-1 do
            alm = MCFGGetKernelStdAlarmHandler(i)
            if alm:externaluse() == false then
                usr_cnt = usr_cnt + 1
            end
        end
    end
    return usr_cnt
end

function inh_count_usr()
    local usr_cnt = 0
    local all_cnt = MCFGGetParamInteger("CFG_INH_COUNT", 0)
    if all_cnt > 0 then
        for i = 0, all_cnt-1 do
            isr = MCFGGetKernelStdInh(i)
            if isr:externaluse() == false then
                usr_cnt = usr_cnt + 1
            end
        end
    end
    return usr_cnt
end

function isr_count_usr()
    local usr_cnt = 0
    local all_cnt = MCFGGetParamInteger("CFG_ISR_COUNT", 0)
    if all_cnt > 0 then
        for i = 0, all_cnt-1 do
            isr = MCFGGetKernelStdIsr(i)
            if isr:externaluse() == false then
                usr_cnt = usr_cnt + 1
            end
        end
    end
    return usr_cnt
end

function dev_count_usr()
    local usr_cnt = 0
    local all_cnt = MCFGGetParamInteger("CFG_DEV_COUNT", 0)
    if all_cnt > 0 then
        for i = 0, all_cnt-1 do
            dev = MCFGGetKernelStdDev(i)
            if dev:externaluse() == false then
                usr_cnt = usr_cnt + 1
            end
        end
    end
    return usr_cnt
end

function exc_count_usr()
    local usr_cnt = 0
    local all_cnt = MCFGGetParamInteger("CFG_EXC_COUNT", 0)
    if all_cnt > 0 then
        for i = 0, all_cnt-1 do
            dev = MCFGGetKernelStdExc(i)
            if dev:externaluse() == false then
                usr_cnt = usr_cnt + 1
            end
        end
    end
    return usr_cnt
end

-- l𕶎ŕԂ
function tskatr2str(atr)
    local stAttr = ""
    
    if bit.band(atr, TA_ACT) == TA_ACT then
        stAttr = "TA_ACT"
    end

    if bit.band(atr, TA_ASM) == TA_ASM then
        if string.len(stAttr) == 0 then
            stAttr = "TA_ASM"
        else
            stAttr = stAttr .. "|TA_ASM"
        end
    else
        if string.len(stAttr) == 0 then
            stAttr = "TA_HLNG"
        else
            stAttr = stAttr ..  "|TA_HLNG"
        end
    end

    if bit.band(atr, TA_USR) ~= 0 then
        if string.len(stAttr) == 0 then
            stAttr = "TA_USR"
        else
            stAttr = stAttr .. "|TA_USR"
        end
    end

    if bit.band(atr, TA_DSP) ~= 0 then
        if string.len(stAttr) == 0 then
            stAttr = "TA_DSP"
        else
            stAttr = stAttr .. "|TA_DSP"
        end
    end

    if bit.band(atr, TA_FPU) ~= 0 then
        if string.len(stAttr) == 0 then
            stAttr = "TA_FPU"
        else
            stAttr = stAttr .. "|TA_FPU"
        end
    end

    if bit.band(atr, TA_VPU) ~= 0 then
        if string.len(stAttr) == 0 then
            stAttr = "TA_VPU"
        else
            stAttr = stAttr .. "|TA_VPU"
        end
    end

    return stAttr
end

function sematr2str(atr)
    local stAttr = ""

    if bit.band(atr, TA_TPRI) ~= 0 then
        stAttr = "TA_TPRI"
    else
        stAttr = "TA_TFIFO"
    end

    return stAttr
end

function flgatr2str(atr)
    local stAttr = ""

    if bit.band(atr, TA_TPRI) ~= 0 then
        stAttr = "TA_TPRI"
    else
        stAttr = "TA_TFIFO"
    end

    if bit.band(atr, TA_WMUL) ~= 0 then
        stAttr = stAttr .. "|TA_WMUL"
    else
        stAttr = stAttr .. "|TA_WSGL"
    end

    if bit.band(atr,  TA_CLR) ~= 0 then
        stAttr = stAttr .. "|TA_CLR"
    end

    return stAttr
end

function dtqatr2str(atr)
    local stAttr = ""

    if bit.band(atr, TA_TPRI) ~= 0 then
        stAttr = "TA_TPRI"
    else
        stAttr = "TA_TFIFO"
    end

    return stAttr
end

function mbxatr2str(atr)
    local stAttr = ""

    if bit.band(atr, TA_TPRI) ~= 0 then
        stAttr = "TA_TPRI"
    else
        stAttr = "TA_TFIFO"
    end

    if bit.band(atr, TA_MPRI) ~= 0 then
		stAttr = stAttr .. "|TA_MPRI"
    else
        stAttr = stAttr .. "|TA_MFIFO"
    end

    return stAttr
end

function mtxatr2str(atr)
    local stAttr = ""

    if atr == TA_TFIFO then 
        stAttr = "TA_TFIFO"
    elseif atr == TA_TPRI then
        stAttr = "TA_TPRI"
    elseif atr == TA_INHERIT then
        stAttr = "TA_INHERIT"
    elseif atr == TA_CEILING then
        stAttr = "TA_CEILING"
    end

    return stAttr
end

function mbfatr2str(atr)
    local stAttr = ""

    if bit.band(atr, TA_TPRI) ~= 0 then
        stAttr = "TA_TPRI"
    else
        stAttr = "TA_TFIFO"
    end

    return stAttr
end

function poratr2str(atr)
    local stAttr = ""

    if bit.band(atr, TA_TPRI) ~= 0 then
        stAttr = "TA_TPRI"
    else
        stAttr = "TA_TFIFO"
    end

    return stAttr
end

function mpfatr2str(atr)
    local stAttr = ""

    if bit.band(atr, TA_TPRI) ~= 0 then
        stAttr = "TA_TPRI"
    else
        stAttr = "TA_TFIFO"
    end

    return stAttr
end

function mplatr2str(atr)
    local stAttr = ""

    if bit.band(atr, TA_TPRI) ~= 0 then
        stAttr = "TA_TPRI"
    else
        stAttr = "TA_TFIFO"
    end

    return stAttr
end

function cycatr2str(atr)
    local stAttr = ""
    
    if bit.band(atr, TA_ASM) == TA_ASM then
        stAttr = "TA_ASM"
    else
        stAttr = "TA_HLNG"
    end

    if bit.band(atr, TA_STA) ~= 0 then
        stAttr = stAttr .. "|TA_STA"
    end

    if bit.band(atr, TA_PHS) ~= 0 then
        stAttr = stAttr .. "|TA_PHS"
    end

    if bit.band(atr, TA_FPU) ~= 0 then
        stAttr = stAttr .. "|TA_FPU"
    end

    if bit.band(atr, TA_VPU) ~= 0 then
        stAttr = stAttr .. "|TA_VPU"
    end

    return stAttr
end

function almatr2str(atr)
    local stAttr = ""
    
    if bit.band(atr, TA_ASM) == TA_ASM then
        stAttr = "TA_ASM"
    else
        stAttr = "TA_HLNG"
    end

    if bit.band(atr, TA_FPU) ~= 0 then
        stAttr = stAttr .. "|TA_FPU"
    end

    if bit.band(atr, TA_VPU) ~= 0 then
        stAttr = stAttr .. "|TA_VPU"
    end

    return stAttr
end

function ovratr2str(atr)
    local stAttr = ""
    
    if bit.band(atr, TA_ASM) == TA_ASM then
        stAttr = "TA_ASM"
    else
        stAttr = "TA_HLNG"
    end

    if bit.band(atr, TA_FPU) ~= 0 then
        stAttr = stAttr .. "|TA_FPU"
    end

    if bit.band(atr, TA_VPU) ~= 0 then
        stAttr = stAttr .. "|TA_VPU"
    end

    return stAttr
end

function inhatr2str(atr)
    local stAttr = ""
    
    if bit.band(atr, TA_ASM) == TA_ASM then
        stAttr = "TA_ASM"
    else
        stAttr = "TA_HLNG"
    end

    if bit.band(atr, TA_FPU) ~= 0 then
        stAttr = stAttr .. "|TA_FPU"
    end

    if bit.band(atr, TA_VPU) ~= 0 then
        stAttr = stAttr .. "|TA_VPU"
    end

    return stAttr
end

function isratr2str(atr)
    local stAttr = ""
    
    if bit.band(atr, TA_ASM) == TA_ASM then
        stAttr = "TA_ASM"
    else
        stAttr = "TA_HLNG"
    end

    if bit.band(atr, TA_FPU) ~= 0 then
        stAttr = stAttr .. "|TA_FPU"
    end

    if bit.band(atr, TA_VPU) ~= 0 then
        stAttr = stAttr .. "|TA_VPU"
    end

    return stAttr
end

function excno2str(no)
    local str = ""
    if no == 1 then
        str = "EXC_UDF"
    elseif no == 2 then
        str = "EXC_SVC"
    elseif no == 3 then
        str = "EXC_PRA"
    elseif no == 4 then
        str = "EXC_DTA"
    end

    return str
end

-- COM|[g
function is_use_com() 
    local uart_cnt = MCFGGetParamInteger("CFG_PERIPH_UART", 0)
    for i = 0, uart_cnt-1 do
        if MCFGGetParamInteger("CFG_PERIPH_UART_USE", i) == 1 then
            return true
        end
    end
    return false
end

-- X^bN[U`ۂ
function is_user_init(func)
    local ret = true

    if func == "STACK_NO_INIT" then
        ret = false
    elseif func == "STACK_ZERO_INIT" then
        ret = false
    elseif func == "STACK_ID_INIT" then
        ret = false
    end

    return ret
end

