/**
  * @file    DDR_RZT1_VIC.c
  * @brief   RZ/T1 Vectored Interrupt Controller (Cortex-R core)
  * @date    2015.04.23
  * @author  Copyright (c) 2014-2015, eForce Co.,Ltd.  All rights reserved.
  *
  * @par     History
  *          - rev 1.0 (2015.04.23) i-cho
  *            Initial version. 
  *          - rev 1.1 (2015.07.02) yokota
  *            add clr_int. 
  */
 
#ifndef _DDR_RZT1_VIC_H_
#define _DDR_RZT1_VIC_H_

#ifdef __cplusplus
extern "C"
{
#endif

/**
  * @brief Interrupt controller initialization routine
  */
void _ddr_rzt1_vic_init(void);

/**
  * @brief  Set external interrupt pin.
  * @param[in] pin ........ External interrupt pin number (0 ~  15)
  * @param[in] detect ..... Interrupt pin detection sense
  * @param[in] clksel ..... sampling clock
  */
ER set_irqpin_int(int pin, int detect, int clksel);

/**
  * @brief  Set interrupt detection type.
  * @param  intno ........ Interrupt line numbe
  * @param  edge_mode .... Trigger mode (0: Level, 1: Edge)
  * @return E_OK ......... Trigger mode set
  *         E_PAR ........ Invalid interrupt number
  */
ER set_type_int(INTNO intno, int edge_mode);

/**
  * @brief  Clear interrupt detection type.
  * @param  intno ........ Interrupt line numbe
  * @return E_OK ......... cler interrupt
  *         E_PAR ........ Invalid interrupt number
  */
ER clr_int(INTNO intno);

#ifdef __cplusplus
}
#endif

#endif  /* _DDR_RZT1_VIC_H_ */

