/***************************************************************************
    Micro C Cube Standard, KERNEL
    ITRON macro definitions for ARMv7-R dependent definitions

    Copyright (c) 2014-2015, eForce Co.,Ltd.  All rights reserved.

    Version Information
            2014.09.30: Created.
            2015.05.08: Changed TKERNEL_PRVER to v1.11.0
            2015.08.28: Changed TKERNEL_PRVER to v1.12.0
***************************************************************************/

#ifndef _ITRON_H_
#define _ITRON_H_

#ifndef NULL
#ifdef __cplusplus
#define NULL    (0)
#else
#define NULL    ((void *)0)
#endif
#endif

#define TRUE    1
#define FALSE   0

#define E_OK    0

#define ID_CORE0            1
#define ID_CORE1            2
#define ID_CORE2            3
#define ID_CORE3            4

#define TA_USR      0x10u

#define _kernel_INT_SIZE    4
#define _kernel_SIZE_SIZE   4
#define _kernel_ALIGN_SIZE  8
#define _kernel_INT_BIT     (_kernel_INT_SIZE*8)

#define TKERNEL_PRID    0x0248
#define TKERNEL_PRVER   0x1120

#define EXC_UDF     1
#define EXC_SVC     2
#define EXC_PRA     3
#define EXC_DTA     4


/************************************
    Byte Order Type
 ************************************/

#if defined (__CC_ARM)      /* for ARM Compiler */
#if defined (__BIG_ENDIAN)
#define _UC3_ENDIAN_BIG
#undef _UC3_ENDIAN_LITTLE
#else
#define _UC3_ENDIAN_LITTLE
#undef _UC3_ENDIAN_BIG
#endif
#elif defined (__ICCARM__)  /* for IAR Compiler */
#if (__LITTLE_ENDIAN__ == 1)
#define _UC3_ENDIAN_LITTLE
#undef _UC3_ENDIAN_BIG
#else
#define _UC3_ENDIAN_BIG
#undef _UC3_ENDIAN_LITTLE
#endif
#elif defined (__TMS470__)  /* for CCS Compiler */
#if defined (__little_endian__)
#define _UC3_ENDIAN_LITTLE
#undef _UC3_ENDIAN_BIG
#else
#define _UC3_ENDIAN_BIG
#undef _UC3_ENDIAN_LITTLE
#endif
#elif defined(__GNUC__)		/* for GNU C */
#if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__
#define _UC3_ENDIAN_LITTLE
#undef _UC3_ENDIAN_BIG
#else
#define _UC3_ENDIAN_BIG
#undef _UC3_ENDIAN_LITTLE
#endif
#endif


/************************************
    Data Types
 ************************************/

typedef signed char B;
typedef signed short H;
typedef signed long W;
typedef unsigned char UB;
typedef unsigned short UH;
typedef unsigned long UW;
typedef char VB;
typedef short VH;
typedef long VW;
typedef void *VP;
typedef void (*FP)(void);

typedef signed long long D;
typedef unsigned long long UD;
typedef long long VD;

typedef unsigned long SIZE;
typedef unsigned long ADDR;

typedef int INT;
typedef unsigned int UINT;

typedef VP VP_INT;

typedef INT BOOL;
typedef INT FN;
typedef INT ER;
typedef INT ID;
typedef INT PRI;
typedef INT BOOL_ID;
typedef INT RDVNO;
typedef INT ER_ID;
typedef INT ER_UINT;
typedef UINT TEXPTN;
typedef UINT FLGPTN;
typedef UINT RDVPTN;
typedef UINT INHNO;
typedef UINT INTNO;
typedef UINT IMASK;
typedef UINT EXCNO;

typedef UINT ATR;
typedef UINT STAT;
typedef UINT MODE;

typedef struct t_systim {
    UW utime;
    UW ltime;
} SYSTIM;

typedef W TMO;

typedef UW RELTIM;
typedef UH OVRTIM;

/************************************
    ARMv7-R dependent definitions
 ************************************/

extern UW vget_fpscr(void);
extern void vset_fpscr(UW fpscr);
extern void vena_vfp(void);
extern void vdis_vfp(void);
extern ER _kernel_enavfp(UW *reg, UW psr);
extern void _kernel_clean_data_cache(void *ptr, SIZE sz);
extern void _kernel_invalid_data_cache(void *ptr, SIZE sz);
extern void _kernel_invalid_inst_cache(void *ptr, SIZE sz);
extern void _kernel_synch_cache(void);
extern UINT get_cid(void);
extern UW _kernel_disable_irq(void);
extern void _kernel_restore_irq(UW cpsr);
extern void _kernel_start_systim(void);
extern void _kernel_stop_systim(void);

#endif /* _ITRON_H_ */
