/***********************************************************************
  Sample program

   Generated at 2015-05-22 16:52:02

 ***********************************************************************/

/* {{UC3_INCLUDE */
#include "kernel.h"
#include "kernel_id.h"
#include "kernel_cfg.h"
#include "hw_dep.h"
#include "net_hdr.h"
#include "net_id.h"
#include "http_server.h"
#include "shell.h"
/* }}UC3_INCLUDE */
#ifdef __IAR_SYSTEMS_ICC__
#include <intrinsics.h>
#endif

#include <string.h>

/******************************************************************
    No Heap
 ******************************************************************/
#ifdef __CC_ARM
#pragma import(__use_no_heap)
#endif

/* {{UC3_CODE */
VB const * const demo_str = "\n\r\tSample Program for eForce Operating System V1.0\n\r\t\tSerial Port (SCIF2)\r\n";
T_COM_SMOD const usart2_ini = {115200, BLEN8, PAR_NONE, SBIT1, FLW_NONE};

/* Port definition */
#define LED1_PODR   (PORTN.PODR.BIT.B7)  /* LD1 */
#define LED2_PODR   (PORTN.PODR.BIT.B6)  /* LD2 */

/******************************************************************
    Default interrupt handler
     Reached when the interrupt is accepted even though it is not the generation of an
     interrupt service routine also define the interrupt handler.
 ******************************************************************/

void int_abort(void)
{
    for(;;);
}

/*******************************
        undefined_instruction_handler
 *******************************/
/* {{UC3_EXC(undefined_instruction_handler) */
void undefined_instruction_handler(UW *reg, UW psr)
{
    ER ercd;
    ercd = _kernel_enavfp(reg, psr);
    if (ercd != E_OK) {
        int_abort();
    }
}
/* }}UC3_EXC */

void puts_com_opt(VB *msg)
{
    UINT txcnt;

    txcnt = strlen(msg);
    puts_com(DID_SCIF2, msg, &txcnt, TMO_FEVR);
}

/* Ether�N���b�NE�iETCLKE�j, Ether�N���b�ND�iETCLKD�j*/
void board_set_eth_clk(void) 
{
    SYSTEM.PRCR.LONG = PRCR_CPG_UNLOCK ;
    SYSTEM.SCKCR.BIT.ETCKD = 3 ; /* 1.563MHz */
    SYSTEM.SCKCR.BIT.ETCKE = 0 ; /* 25MHz (MII) */
    SYSTEM.PRCR.LONG = PRCR_CPG_LOCK ;
}

#define ETSPCMD_PROTECT_ON()  { ETHERC.ETSPCMD.LONG = 0x00UL; }
#define ETSPCMD_PROTECT_OFF() { ETHERC.ETSPCMD.LONG = 0x000000A5UL; \
                                ETHERC.ETSPCMD.LONG = 0x00000001UL; \
                                ETHERC.ETSPCMD.LONG = 0x0000FFFEUL; \
                                ETHERC.ETSPCMD.LONG = 0x00000001UL; \
                              }

/* �{�[�h�ˑ��̃C�[�T�l�b�g�̏����� */
void board_eth_ini(void)
{

    /* Protect OFF */
    ETSPCMD_PROTECT_OFF();
    
    ETHERC.MII_CTRL0.BIT.MODE = 0x00; /* MII */
    ETHERC.MII_CTRL1.BIT.MODE = 0x00; /* MII */
    ETHERC.MII_CTRL2.BIT.MODE = 0x00; /* MII */
    
    /* PHY���Z�b�g���� */
    ETHERC.ETHSFTRST.BIT.PHYRST2 = 1;
    ETHERC.ETHSFTRST.BIT.PHYRST  = 1;

    /* Protect ON */
    ETSPCMD_PROTECT_ON();
}

/*******************************
        MainTask
 *******************************/
extern ER net_setup(void);
/* {{UC3_TASK(MainTask) */
void MainTask(VP_INT exinf)
{
    UINT txcnt;
    ER ercd;
    extern TMO LedTmo;

    LED1_PODR = 0;
    LED2_PODR = 0;
    
    ini_com(DID_SCIF2, &usart2_ini);
    dly_tsk(1);
    ctr_com(DID_SCIF2, STA_COM, 0);
    
    txcnt = strlen(demo_str);
    puts_com(DID_SCIF2, (VB *)demo_str, &txcnt, TMO_FEVR);

    {
        extern ER eth_hwfunc_ini(void);
        ercd = eth_hwfunc_ini();
        if (ercd != E_OK) {
            return;
        }
    }
    
    /* Initialize uNet3 */
    ercd = net_setup();
    if (ercd != E_OK) {
        return;
    }

    /* Initialize Console */
    ercd = sta_tsk(ID_NET_CONSOLE_TSK, 0);
    
    for (;;) {
        LED1_PODR = 1;
        LED2_PODR = 0;
        dly_tsk(LedTmo);
        LED1_PODR = 0;
        LED2_PODR = 1;
        dly_tsk(LedTmo);
    }
}
/* }}UC3_TASK */


/*******************************
        net_console_tsk
 *******************************/
/* {{UC3_TASK(net_console_tsk) */
/* Control Block */
static T_SHELL_CTL net_ctl_console;
void net_console_tsk(VP_INT exinf)
{
    net_memset(&net_ctl_console, 0, sizeof(T_SHELL_CTL));

    net_ctl_console.typ = TYP_COM;
    net_ctl_console.com_id = DID_SCIF2;

    shell_sta(&net_ctl_console);
   
}
/* }}UC3_TASK */



/*******************************
        Main entry
 *******************************/

extern void hw_init(void);
extern void init_csys(T_CSYS* );
extern void initpr(void);

int main(void)
{
    T_CSYS csys;


    /* Initialize H/W */
    //hw_init();
    init_port();
    _ddr_rzt1_vic_init();

    board_set_eth_clk(); /* Ether�N���b�NE�iETCLKE�j, Ether�N���b�ND�iETCLKD�j*/
    board_eth_ini();     /* �{�[�h�ˑ��̃C�[�T�l�b�g������ */
    
    /* Generate system */
    init_csys(&csys);

    return (int)start_uC3(&csys, initpr);
}

/* end */
