/**
 * @file    sample.c
 * @brief   Serial flash boot sample program
 * @date    2015.05.01
 * @author  Copyright (c) 2015, eForce Co.,Ltd.  All rights reserved.
 *
 ****************************************************************************
 *  Histroy     : 2015.04.15  Created.
 *              : 2015.05.01
 *                Removed IO initialization function.
 ****************************************************************************
 */

/* {{UC3_INCLUDE */
#include "kernel.h"
#include "kernel_id.h"
#include "kernel_cfg.h"
#include "RZT1_UC3.h"
#include "hw_dep.h"
/* }}UC3_INCLUDE */
#ifdef __IAR_SYSTEMS_ICC__
#include <intrinsics.h>
#endif

#include <string.h>

/* Port definition */
#define LED1_PODR   (PORTN.PODR.BIT.B6)
#define LED2_PODR   (PORTN.PODR.BIT.B7)

VB const * const demo_str = "\n\r\tSample Program for eForce Operating System V1.0\n\r\t\tSerial Port (SCIFA2)\r\n";
T_COM_SMOD const usart2_ini = {115200, BLEN8, PAR_NONE, SBIT1, FLW_NONE};


/******************************************************************
    No Heap
 ******************************************************************/
#ifdef __CC_ARM
#pragma import(__use_no_heap)
#endif

/* {{UC3_CODE */


/******************************************************************
    Default interrupt handler
     Reached when the interrupt is accepted even though it is not the generation of an
     interrupt service routine also define the interrupt handler.
 ******************************************************************/

void int_abort(void)
{
    for(;;);
}

/*******************************
        undefined_instruction_handler
 *******************************/
/* {{UC3_EXC(undefined_instruction_handler) */
void undefined_instruction_handler(UW *reg, UW psr)
{
    ER ercd;
    ercd = _kernel_enavfp(reg, psr);
    if (ercd != E_OK) {
        int_abort();
    }
}
/* }}UC3_EXC */
void inth_funcXXX(void)
{
   clr_int(84);
}


T_DINH _kernel_dinh1 = {84,  inth_funcXXX, 10};

/*******************************
        MainTask
 *******************************/
/* {{UC3_TASK(MainTask) */
void MainTask(VP_INT exinf)
{
    ER ercd = def_inh(84, (T_DINH *)&_kernel_dinh1);
    if (ercd == E_OK) {
    PORTN.PODR.BIT.B6 = 1;
    PORTN.PODR.BIT.B7 = 1;
    PORTN.PDR.BIT.B6 = 3;
    PORTN.PDR.BIT.B7 = 3;
    LED1_PODR = 0;
    LED2_PODR = 0;
    set_type_int(152, 1); ena_int(152);
    set_type_int(84, 1);  ena_int(84);   // RSPI1 RXI
    set_type_int(85, 1);  ena_int(85);   // RSPI1 TXI
    set_type_int(86, 0);  ena_int(86);   // RSPI1 ERI
    for(;;) {
        LED1_PODR = 1;
        LED2_PODR = 0;
        dly_tsk(500);
        LED1_PODR = 0;
        LED2_PODR = 1;
        dly_tsk(500);
    }
    }
}
/* }}UC3_TASK */

/*******************************
        ComTask
 *******************************/
/* {{UC3_TASK(ComTask) */
void ComTask(VP_INT exinf)
{
    UINT txcnt;
    VB chr;
    ini_com(DID_SCIF2, &usart2_ini);
    dly_tsk(1);
    ctr_com(DID_SCIF2, STA_COM, 0);

    txcnt = strlen(demo_str);
    puts_com(DID_SCIF2, (VB *)demo_str, &txcnt, TMO_FEVR);

    for(;;) {
        getc_com(DID_SCIF2, &chr, 0, TMO_FEVR);
        putc_com(DID_SCIF2, chr, TMO_FEVR);
    }
}
/* }}UC3_TASK */


/* }}UC3_CODE */

/*******************************
        Main entry
 *******************************/

extern void init_port(void);
extern void init_csys(T_CSYS* );
extern void initpr(void);

int main(void)
{
    T_CSYS csys;
    volatile uint32_t dummy;
    SYSTEM.PRCR.LONG = PRCR_MSTP_UNLOCK;
    dummy = SYSTEM.PRCR.LONG;

    SYSTEM.MSTPCRB.BIT.MSTPCRB12 = 0;
    dummy = SYSTEM.MSTPCRB.LONG;
    SYSTEM.PRCR.LONG = PRCR_MSTP_LOCK;
    dummy = SYSTEM.PRCR.LONG;
    /* Initialize H/W */
    hw_init();
     _ddr_rzt1_vic_init();

    /* Generate system */
    init_csys(&csys);

    return (int)start_uC3(&csys, initpr);
}



