/*******************************************************************************
* DISCLAIMER
* This software is supplied by Renesas Electronics Corporation and is only
* intended for use with Renesas products. No other uses are authorized. This
* software is owned by Renesas Electronics Corporation and is protected under
* all applicable laws, including copyright laws.
* THIS SOFTWARE IS PROVIDED "AS IS" AND RENESAS MAKES NO WARRANTIES REGARDING
* THIS SOFTWARE, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING BUT NOT
* LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
* AND NON-INFRINGEMENT. ALL SUCH WARRANTIES ARE EXPRESSLY DISCLAIMED.
* TO THE MAXIMUM EXTENT PERMITTED NOT PROHIBITED BY LAW, NEITHER RENESAS
* ELECTRONICS CORPORATION NOR ANY OF ITS AFFILIATED COMPANIES SHALL BE LIABLE
* FOR ANY DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES FOR
* ANY REASON RELATED TO THIS SOFTWARE, EVEN IF RENESAS OR ITS AFFILIATES HAVE
* BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
* Renesas reserves the right, without notice, to make changes to this software
* and to discontinue the availability of this software. By using this software,
* you agree to the additional terms and conditions found by accessing the
* following link:
* http://www.renesas.com/disclaimer
*
* Copyright (C) 2015 Renesas Electronics Corporation. All rights reserved.
*******************************************************************************/
/*******************************************************************************
* System Name  : RZ/T1 Sample program
* File Name    : loader_init2.c
* Version      : 1.10
* Device       : R7S910017
* Abstract     : Loader program 2
* Tool-Chain   : e2studio
* OS           : not use
* H/W Platform : RZ/T1 Evaluation Board (RTK7910022C00000BR)
* Description  : Initialize the peripheral settings of RZ/T1
* Limitation   : none
*******************************************************************************/
/*******************************************************************************
* History      : DD.MM.YYYY Version  Description
*              : 31.10.2015 1.10     First Release
*******************************************************************************/

/*******************************************************************************
Includes <System Includes> , "Project Includes"
*******************************************************************************/
#include <stdint.h>
#include "iodefine.h"
#include "r_system.h"
#include "r_reset.h"
#include "r_cpg.h"
#include "r_atcm_init.h"
#include "r_port.h"
#include "r_mpc.h"
#include "r_ecm.h"

/*******************************************************************************
Macro definitions
*******************************************************************************/

/*******************************************************************************
Typedef definitions
*******************************************************************************/

/*******************************************************************************
Imported global variables and functions (from other files)
*******************************************************************************/
extern int _main(void);
extern void bus_init(void);
extern void set_low_vec(void);
extern void cache_init(void);
extern void copy_cm3(void);
extern void Reset_Handler(void);
/*******************************************************************************
Exported global variables and functions (to be accessed by other files)
*******************************************************************************/

/*******************************************************************************
Private variables and functions
*******************************************************************************/
void loader_init2(void) __attribute__ ((section (".loader_text2")));
void reset_check(void) __attribute__ ((section (".loader_text2")));
void cpg_init(void) __attribute__ ((section (".loader_text2")));

#ifdef _RUN_SDRAM_
static void zero_init(void)
{
    uint32_t *zblock;
    uint32_t size;
    uint32_t fill_count;
    uint32_t loop;
    extern const uint32_t _bss;
    extern const uint32_t _ebss;

    zblock  = (uint32_t *)((uint32_t *) &_bss);
    size    = (((uint32_t) &_ebss) - ((uint32_t)&_bss));

    fill_count = (size + 3) >> 2;

    for (loop = 0; loop < fill_count; loop++) {
        *zblock++ = 0x0;
    }
}
#endif

/*******************************************************************************
* Function Name : loader_init2
* Description   : Initialize sysytem by loader program 2
* Arguments    : none
* Return Value : none
*******************************************************************************/
void loader_init2(void)
{ 
    /* Check the reset source */
    reset_check();
  
    /* Set CPU clock and LOCO clock */
    cpg_init();
    
    /* Set ATCM access wait to 1-wait with optimization */
    /* Caution: ATCM_WAIT_0 is permitted if CPUCLK = 150MHz or 300MHz.
                ATCM_WAIT_1_OPT is permitted if CPUCLK = 450MHz or 600MHz.*/
    R_ATCM_WaitSet(ATCM_WAIT_1_OPT);

    /* Initialize the bus settings */
    bus_init();

    /* Copy the application program from external memory to RAM */
    copy_to_ram();

    /* Initialize I1, D1 Cache and MPU setting */
    cache_init();
    
    /* Set RZ/T1 to Low-vector (SCTLR.V = 0) */
    set_low_vec();

    /*copy_cm3();*/
#ifdef _RUN_SDRAM_
    zero_init();
#endif
    /* Jump to _main() */
    Reset_Handler();

}


/*******************************************************************************
 End of function loader_init2
*******************************************************************************/

/*******************************************************************************
* Function Name : reset_check
* Description   : Check the reset source and execute the each sequence.
*                 When error source number 35 is generated, set P77 pin to High.
* Arguments    : none
* Return Value : none
*******************************************************************************/
void reset_check(void)
{
    volatile uint8_t result;
    volatile uint32_t dummy;
    
    /* Check the reset status flag and execute the each sequence */
    if (RST_SOURCE_ECM == SYSTEM.RSTSR0.LONG) // ECM reset is generated
    {
        /* Clear reset status flag */ 
        R_RST_WriteEnable();              // Enable writing to the RSTSR0 register
        SYSTEM.RSTSR0.LONG = 0x00000000;  // Clear reset factor flag
        R_RST_WriteDisable();             // Disable writing to the RSTSR0 register
        
        /* Please coding the User program */ 
        
    }
    else if (RST_SOURCE_SWR1 == SYSTEM.RSTSR0.LONG) // Software reset 1 is generated
    {
        /* Clear reset status flag */ 
        R_RST_WriteEnable();              // Enable writing to the RSTSR0 register
        SYSTEM.RSTSR0.LONG = 0x00000000;  // Clear reset factor flag
        R_RST_WriteDisable();             // Disable writing to the RSTSR0 register
        
        /* Please coding the User program */  
        
    }
    else if (RST_SOURCE_RES == SYSTEM.RSTSR0.LONG) // RES# pin reset is generated
    {
        /* Clear reset status flag */ 
        R_RST_WriteEnable();              // Enable writing to the RSTSR0 register
        SYSTEM.RSTSR0.LONG = 0x00000000;  // Clear reset factor flag
        R_RST_WriteDisable();             // Disable writing to the RSTSR0 register
        
        /* Please coding the User program */    
        
    }
    else // Any reset is not generated
    {        
        /* Please coding the User program */  
    }

}

/*******************************************************************************
 End of function reset_check
*******************************************************************************/

/*******************************************************************************
* Function Name : cpg_init
* Description   : Set CPU clock and LOCO clock by CPG function
* Arguments    : none
* Return Value : none
*******************************************************************************/
void cpg_init(void)
{
    volatile uint32_t dummy; 
      
    /* Enables writing to the registers related to CPG function */
    R_CPG_WriteEnable();
    
    /* Enables LOCO clock operation */
    SYSTEM.LOCOCR.BIT.LCSTP = CPG_LOCO_ENABLE;
    
    /* Set CPUCLK to 450MHz, and dummy read at three times */
    SYSTEM.PLL1CR.LONG = CPG_CPUCLK_450_MHz;
    dummy = SYSTEM.PLL1CR.LONG;
    dummy = SYSTEM.PLL1CR.LONG;
    dummy = SYSTEM.PLL1CR.LONG;
     
    /* Enables PLL1 operation */
    SYSTEM.PLL1CR2.LONG = CPG_PLL1_ON;    
    
    /* Disables writing to the registers related to CPG function */
    R_CPG_WriteDisable(); 
    
    /* Wait about 100us for PLL1 (and LOCO) stabilization */
    R_CPG_PLL_Wait();

    /* Enables writing to the registers related to CPG function */
    R_CPG_WriteEnable();  
     
    /* Selects the PLL1 as clock source */
    SYSTEM.SCKCR2.LONG = CPG_SELECT_PLL1;
    
    /* Disables writing to the registers related to CPG function */
    R_CPG_WriteDisable();
  
}

/*******************************************************************************
 End of function cpg_init
*******************************************************************************/

/* End of File */


